%% load data
clc;
clear;

% file names and locations
trainFeaturesFile = ['C:\Users\n01388138\Downloads\' ...
    'train-modelnet40-voxel-5.txt'];
testFeaturesFile = ['C:\Users\n01388138\Downloads\' ...
    'test-modelnet40-voxel-5.txt'];


% Load training data (each file contains rows of X numbers)
data = readtable(trainFeaturesFile);
features = width(data)-1;
XTrain = data(:,1:features);  
XTrain = permute(table2array(XTrain), [2,1]);
YTrain40 = data(:,features+1);  
YTrain = categorical(table2array(YTrain40(:,1)));

% set up test data
dataTest = readtable(testFeaturesFile);
XTest = dataTest(:,1:features);  
XTest = permute(table2array(XTest), [2,1]);
YTest40 = dataTest(:,features+1);  
YTest = categorical(table2array(YTest40(:,1)));


dataset = 40;

fprintf('\t\t Done with data loading.\n\n');

%% for modelnet 10 dataset ONLY
dataset = 10;
if dataset == 10
    model10classes = readlines(['C:\Users\Documents\' ...
        'modelnet10_shape_names.txt']);
    MN10rowsTr = ismember(YTrain, categorical(model10classes));
    XTrain = XTrain(:, MN10rowsTr);
    YTr10 = YTrain40(MN10rowsTr, :);
    YTr10 = categorical(table2array(YTr10));

    MN10rowsTs = ismember(YTest, categorical(model10classes));
    XTest = XTest(:,MN10rowsTs);
    YTs10 = YTest40(MN10rowsTs, :);
    YTs10 = categorical(table2array(YTs10));
end % up to this



%% run n times for various feature lengths
%tic
if dataset == 10
    numClasses = numel(unique(YTr10));
else
    numClasses = numel(unique(YTrain));
end

maxRuns = 1;
%T = zeros(1,maxRuns);
stats = [];
maxOA = 0; maxmAcc = 0;
for length = 1728:-36:1728
    sm=0; sumMacc = 0;
    %%%%%%%%%%%%%%%% only for feature length variations
    XTrain = XTrain (1:length,:);
    XTest = XTest (1:length,:);
    %%%%%%%%%%%%%%%% up to this
    [f, ~] = size(XTrain);

    for run = 1:maxRuns % runs for statistical significance
        rng(run); % controlled randomness
        layers = [
            sequenceInputLayer(f)   

            convolution1dLayer(3, 128, 'Padding', 'same')  
            batchNormalizationLayer
            reluLayer
            
            convolution1dLayer(5, 64, 'Padding', 'same')  
            batchNormalizationLayer
            reluLayer

            convolution1dLayer(7, 40, 'Padding', 'same')  
            batchNormalizationLayer
            reluLayer
            
            fullyConnectedLayer(numClasses)  % Output layer (number of classes in Y)
            softmaxLayer
            classificationLayer
            ];

        %analyzeNetwork(layers);

        % Options for training the network
        lossThreshold = 0.005;

        % 'Plots', 'training-progress', ...
        options = trainingOptions('adam', ...
            'MaxEpochs', 1000, ...
            'MiniBatchSize', 128, ...
            'ExecutionEnvironment',"gpu", ...
            'Verbose', false, ...
            'VerboseFrequency', 50, ...
            OutputFcn=@(info)stopTraining(info,lossThreshold));

        % train the model
        %tic
        if dataset == 10
            [net, trnInfo] = trainNetwork(XTrain, YTr10', layers, options);
        else
            [net, trnInfo] = trainNetwork(XTrain, YTrain', layers, options);
        end
        %T(run) = toc;
        % test the trained model
        [YPred, scores] = classify(net,XTest);
        YPred = YPred';
        if dataset==10
            OA = mean(YPred == YTs10)*100;
            YTrue = YTs10;
            sm = sm + OA;
            if(OA>maxOA)
                maxOA = OA;
                bestModel = net; % save the best model so far
            end
        else
            OA = mean(YPred == YTest)*100;
            YTrue = YTest;
            sm = sm + OA;
            if(OA>maxOA)
                maxOA = OA;
                bestModel = net; % save the best model so far
            end
        end
        % avegare class accuracy -- mAcc
        clear sum
        classAccuracy = zeros(1, numClasses);
        YTrue_uniq = unique(YTrue);
        for i = 1:numClasses
            classLabels = YTrue == YTrue_uniq(i);
            correctPredictions = YPred(classLabels) == YTrue(classLabels);
            classAccuracy(i) = sum(correctPredictions) / sum(classLabels);
        end
        mAcc = mean(classAccuracy)*100;
        sumMacc = sumMacc + mAcc;
        if(mAcc>maxmAcc)
            maxmAcc = mAcc;
        end
        stats = [stats; f, OA, mAcc]; % save the stats
        fprintf('length: %d, run: %d, OA: %.2f%%, mAcc: %.2f%%\n', f, run, OA, mAcc);
    end
    fprintf("AVG and MAX OA after %d runs with length %d is %.2f%% and %.2f%%\n", run,f,sm/run,maxOA);
    fprintf("AVG and MAX mAcc after %d runs with length %d is %.2f%% and %.2f%%\n", run,f,sumMacc/run,maxmAcc);
end

%toc

%% plot confusion matrix
fig = figure;
classnames = unique(YTrue);
c = confusionmat(YTrue,YPred);
cm = confusionchart(YTrue,YPred,'RowSummary','row-normalized', ...
    'ColumnSummary','column-normalized');
fig_Position = fig.Position;
fig_Position(3) = fig_Position(3)*1.5;
fig.Position = fig_Position;
sortClasses(cm,'descending-diagonal')
cm.Normalization = 'absolute';

%% utility functions
function stop = stopTraining(info,lossThreshold)
trainingLoss = info.TrainingLoss;
stop = trainingLoss < lossThreshold;
end

